# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: Not Provided

def serendipitous_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    # Initial Phase (First 2 Rounds)
    if len(my_history) == 1:
        return "C" if opp_history[0] == "C" else "D"
    
    # Mid-Game (Rounds 3-7)
    if len(my_history) < 7:
        # Check for static strategies in opponent's code
        always_defect = "return 'D'" in opponent_program_code.replace(" ", "")
        always_cooperate = "return 'C'" in opponent_program_code.replace(" ", "")
        if always_defect:
            return "C"
        if always_cooperate:
            return "D"
        
        # Check for Tit-for-Tat patterns
        tit_for_tat = "opp_history[-1]" in opponent_program_code.replace(" ", "")
        if tit_for_tat and len(my_history) % 3 == 0:
            return "D"
        
        # History-based moves
        if opp_history[-1] == "D":
            return "D" if random.random() < 0.8 else "C"
        if len(opp_history) >= 2 and opp_history[-1] == "C" and opp_history[-2] == "C":
            return "C" if random.random() < 0.9 else "D"
        return opp_history[-1]
    
    # End-Game (Rounds 8-10)
    # Calculate opponent's cooperation rate
    coop_rate = opp_history.count("C") / len(opp_history)
    if coop_rate >= 0.7:
        if len(my_history) == 8:
            return "C"
        return "D" if len(my_history) == 9 else "D"
    
    # If opponent is retaliatory
    if len(my_history) >= 2 and my_history[-1] == "D" and opp_history[-1] == "D":
        return "C" if len(my_history) == 7 else "D"
    
    # Default: mirror opponent's last move
    return opp_history[-1]